package FlashReader;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;

public class SwfTools {
	
	protected final int OP_bkpt = 0x01;
	protected final int OP_nop = 0x02;
	protected final int OP_throw = 0x03;
	protected final int OP_getsuper = 0x04;
	protected final int OP_setsuper = 0x05;
	protected final int OP_dxns = 0x06;
	protected final int OP_dxnslate = 0x07;
	protected final int OP_kill = 0x08;
	protected final int OP_label = 0x09;
	protected final int OP_ifnlt = 0x0C;
	protected final int OP_ifnle = 0x0D;
	protected final int OP_ifngt = 0x0E;
	protected final int OP_ifnge = 0x0F;
	protected final int OP_jump = 0x10;
	protected final int OP_iftrue = 0x11;
	protected final int OP_iffalse = 0x12;
	protected final int OP_ifeq = 0x13;
	protected final int OP_ifne = 0x14;
	protected final int OP_iflt = 0x15;
	protected final int OP_ifle = 0x16;
	protected final int OP_ifgt = 0x17;
	protected final int OP_ifge = 0x18;
	protected final int OP_ifstricteq = 0x19;
	protected final int OP_ifstrictne = 0x1A;
	protected final int OP_lookupswitch = 0x1B;
	protected final int OP_pushwith = 0x1C;
	protected final int OP_popscope = 0x1D;
	protected final int OP_nextname = 0x1E;
	protected final int OP_hasnext = 0x1F;
	protected final int OP_pushnull = 0x20;
	protected final int OP_pushundefined = 0x21;
	protected final int OP_pushconstant = 0x22;
	protected final int OP_nextvalue = 0x23;
	protected final int OP_pushbyte = 0x24;
	protected final int OP_pushshort = 0x25;
	protected final int OP_pushtrue = 0x26;
	protected final int OP_pushfalse = 0x27;
	protected final int OP_pushnan = 0x28;
	protected final int OP_pop = 0x29;
	protected final int OP_dup = 0x2A;
	protected final int OP_swap = 0x2B;
	protected final int OP_pushstring = 0x2C;
	protected final int OP_pushint = 0x2D;
	protected final int OP_pushuint = 0x2E;
	protected final int OP_pushdouble = 0x2F;
	protected final int OP_pushscope = 0x30;
	protected final int OP_pushnamespace = 0x31;
	protected final int OP_hasnext2 = 0x32;
	protected final int OP_newfunction = 0x40;
	protected final int OP_call = 0x41;
	protected final int OP_construct = 0x42;
	protected final int OP_callmethod = 0x43;
	protected final int OP_callstatic = 0x44;
	protected final int OP_callsuper = 0x45;
	protected final int OP_callproperty = 0x46;
	protected final int OP_returnvoid = 0x47;
	protected final int OP_returnvalue = 0x48;
	protected final int OP_constructsuper = 0x49;
	protected final int OP_constructprop = 0x4A;
	protected final int OP_callsuperid = 0x4B;
	protected final int OP_callproplex = 0x4C;
	protected final int OP_callinterface = 0x4D;
	protected final int OP_callsupervoid = 0x4E;
	protected final int OP_callpropvoid = 0x4F;
	protected final int OP_newobject = 0x55;
	protected final int OP_newarray = 0x56;
	protected final int OP_newactivation = 0x57;
	protected final int OP_newclass = 0x58;
	protected final int OP_getdescendants = 0x59;
	protected final int OP_newcatch = 0x5A;
	protected final int OP_findpropstrict = 0x5D;
	protected final int OP_findproperty = 0x5E;
	protected final int OP_finddef = 0x5F;
	protected final int OP_getlex = 0x60;
	protected final int OP_setproperty = 0x61;
	protected final int OP_getlocal = 0x62;
	protected final int OP_setlocal = 0x63;
	protected final int OP_getglobalscope = 0x64;
	protected final int OP_getscopeobject = 0x65;
	protected final int OP_getproperty = 0x66;
	protected final int OP_getpropertylate = 0x67;
	protected final int OP_initproperty = 0x68;
	protected final int OP_setpropertylate = 0x69;
	protected final int OP_deleteproperty = 0x6A;
	protected final int OP_deletepropertylate = 0x6B;
	protected final int OP_getslot = 0x6C;
	protected final int OP_setslot = 0x6D;
	protected final int OP_getglobalslot = 0x6E;
	protected final int OP_setglobalslot = 0x6F;
	protected final int OP_convert_s = 0x70;
	protected final int OP_esc_xelem = 0x71;
	protected final int OP_esc_xattr = 0x72;
	protected final int OP_convert_i = 0x73;
	protected final int OP_convert_u = 0x74;
	protected final int OP_convert_d = 0x75;
	protected final int OP_convert_b = 0x76;
	protected final int OP_convert_o = 0x77;
	protected final int OP_coerce = 0x80;
	protected final int OP_coerce_b = 0x81;
	protected final int OP_coerce_a = 0x82;
	protected final int OP_coerce_i = 0x83;
	protected final int OP_coerce_d = 0x84;
	protected final int OP_coerce_s = 0x85;
	protected final int OP_astype = 0x86;
	protected final int OP_astypelate = 0x87;
	protected final int OP_coerce_u = 0x88;
	protected final int OP_coerce_o = 0x89;
	protected final int OP_negate = 0x90;
	protected final int OP_increment = 0x91;
	protected final int OP_inclocal = 0x92;
	protected final int OP_decrement = 0x93;
	protected final int OP_declocal = 0x94;
	protected final int OP_typeof = 0x95;
	protected final int OP_not = 0x96;
	protected final int OP_bitnot = 0x97;
	protected final int OP_concat = 0x9A;
	protected final int OP_add_d = 0x9B;
	protected final int OP_add = 0xA0;
	protected final int OP_subtract = 0xA1;
	protected final int OP_multiply = 0xA2;
	protected final int OP_divide = 0xA3;
	protected final int OP_modulo = 0xA4;
	protected final int OP_lshift = 0xA5;
	protected final int OP_rshift = 0xA6;
	protected final int OP_urshift = 0xA7;
	protected final int OP_bitand = 0xA8;
	protected final int OP_bitor = 0xA9;
	protected final int OP_bitxor = 0xAA;
	protected final int OP_equals = 0xAB;
	protected final int OP_strictequals = 0xAC;
	protected final int OP_lessthan = 0xAD;
	protected final int OP_lessequals = 0xAE;
	protected final int OP_greaterthan = 0xAF;
	protected final int OP_greaterequals = 0xB0;
	protected final int OP_instanceof = 0xB1;
	protected final int OP_istype = 0xB2;
	protected final int OP_istypelate = 0xB3;
	protected final int OP_in = 0xB4;
	protected final int OP_increment_i = 0xC0;
	protected final int OP_decrement_i = 0xC1;
	protected final int OP_inclocal_i = 0xC2;
	protected final int OP_declocal_i = 0xC3;
	protected final int OP_negate_i = 0xC4;
	protected final int OP_add_i = 0xC5;
	protected final int OP_subtract_i = 0xC6;
	protected final int OP_multiply_i = 0xC7;
	protected final int OP_getlocal0 = 0xD0;
	protected final int OP_getlocal1 = 0xD1;
	protected final int OP_getlocal2 = 0xD2;
	protected final int OP_getlocal3 = 0xD3;
	protected final int OP_setlocal0 = 0xD4;
	protected final int OP_setlocal1 = 0xD5;
	protected final int OP_setlocal2 = 0xD6;
	protected final int OP_setlocal3 = 0xD7;
	protected final int OP_debug = 0xEF;
	protected final int OP_debugline = 0xF0;
	protected final int OP_debugfile = 0xF1;
	protected final int OP_bkptline = 0xF2;
	
	
	public static int bitPos;
	public static int bitBuf;
	
	public static int unsignedInt(int b) {
	    return  b & 0xFFFFFFFF;
	 }

	public static int unsignedByte(byte b) {
		return (int) b & 0xFF;
	}

	public static int unsignedShort(short b) {
		    return (int) b & 0xFFFF;
	}
	
	public static int unsigned30int(ByteBuffer bbuf){
		int  result = unsignedByte(bbuf.get());
	
		if (!( (result & 0x00000080)>0))
				return result;
		result = result & 0x0000007f | unsignedByte(bbuf.get())<<7;
		if (!( (result & 0x00004000)>0))
			return result;
		result = result & 0x00003fff | unsignedByte(bbuf.get())<<14;
		if (!(  (result & 0x00200000)>0   ))
			return result;
		result = result & 0x001fffff | unsignedByte(bbuf.get())<<21;
		if (!(   (result & 0x10000000)>0   ))
			return result;
		return   result & 0x0fffffff | unsignedByte(bbuf.get())<<28;

	}
	
	public static int  readS24(ByteBuffer bbuf)
	{
		int b = unsignedByte(bbuf.get());
		b |= unsignedByte(bbuf.get())<<8;
		b |= bbuf.get()<<16;
		return b;
	}

	public static void syncBits(){
		bitPos = 0;
	}

	
	 public static int readSBits(int numBits, ByteBuffer bbuf)
	    {
	        if (numBits > 32)
	            throw new Error("Number of bits > 32");

	       int num = readUBits(numBits,bbuf);
	       int shift = 32-numBits;
	        // sign extension
	        num = (num << shift) >> shift;
	        return num;
	    }

	//Zaporzyczone z projektu Tamarin abcdump
		public static int readUBits(int numBits, ByteBuffer bbuf)
	    {
	        if (numBits == 0)
	        	return 0;

	        int bitsLeft = numBits;
	        int result = 0;

	        if (bitPos == 0) //no value in the buffer - read a byte
	        {
		        bitBuf = unsignedByte(bbuf.get());
		        bitPos = 8;
	        }

	        while (true)
	        {
	            int shift = bitsLeft - bitPos;
	           // System.out.println("dupka2 " + shift);
	            if (shift > 0)
	            {
	                // Consume the entire buffer
	                result |= bitBuf << shift;
	                bitsLeft -= bitPos;
	                // Get the next byte from the input stream
	                bitBuf = unsignedByte(bbuf.get());
	                bitPos = 8;
	                
	            }
	            else
	            {
	                // Consume a portion of the buffer
	                result |= bitBuf >> -shift;
	                bitPos -= bitsLeft;
	                bitBuf &= 0xff >> (8 - bitPos); // mask off the consumed bits
//	                if (print) //////// ("  read"+numBits+" " + result);
	                return result;
	            }
	        }
	    }
	
	
	public static int signed32int(ByteBuffer bbuf){
		
		int  result = bbuf.get();

		if (!( (result & 0x00000080)>0)){
				return result;
		}
		result = result & 0x0000007f | bbuf.get()<<7;
		
		if (!( (result & 0x00004000)>0)){
			return result;
		}
		result = result & 0x00003fff | bbuf.get()<<14;

		if (!(  (result & 0x00200000)>0   )){
			return result;
		}
		result = result & 0x001fffff | bbuf.get()<<21;
		
		
		if (!(   (result & 0x10000000)>0   )){
			return result;
		}
		
		return   result & 0x0fffffff | bbuf.get()<<28;
		
	}
	
	public static int unsigned32int(ByteBuffer bbuf){
		
		int  result = unsignedByte(bbuf.get());
		
		if (!( (result & 0x00000080)>0))
				return result;
		result = result & 0x0000007f | unsignedByte(bbuf.get())<<7;
		if (!( (result & 0x00004000)>0))
			return result;
		result = result & 0x00003fff | unsignedByte(bbuf.get())<<14;
		if (!(  (result & 0x00200000)>0   ))
			return result;
		result = result & 0x001fffff | unsignedByte(bbuf.get())<<21;
		if (!(   (result & 0x10000000)>0   ))
			return result;
		return   result & 0x0fffffff | unsignedByte(bbuf.get())<<28;
		
	}


	public static ArrayList<Byte> getUI32(int i){
		ArrayList<Byte> al = new ArrayList<Byte>();
		
		if ( i <= 0x7F ){
			al.add((byte) i);
			return al;
			
		}else if ( i <= 0x3FFF && i>= 0x80 ){
			int i1 =  ((i & 0x7F) | 0x80);
			int i2=  ((i >> 7));
			al.add((byte) i1);
			al.add((byte) i2);
			
			return al;
			
		}else if ( i <= 0x1FFFFF  && i>=0x4000   ){
			int i1 = (((i & 0x7F) | 0x80));
			int i2 = (((i >> 7) | 0x80));
			int i3 = ((i>> 14));
			al.add((byte) i1);
			al.add((byte) i2);
			al.add((byte) i3);
			return al;
			
		}else if ( i <= 0xFFFFFFF   && i>=0x200000    ){
			int i1 = (((i & 0x7F) | 0x80));
			int i2 =  (((i >> 7) | 0x80));
			int i3 =  (((i >> 14) | 0x80));
			int i4=  ((i>> 21));
			al.add((byte) i1);
			al.add((byte) i2);
			al.add((byte) i3);
			al.add((byte) i4);
			return al;
			
			
		}else if (i>= 0x10000000    ){
			int i1 =  (((i & 0x7F) | 0x80));
			int i2 =  (((i >> 7) | 0x80));
			int i3 =  (((i >> 14) | 0x80));
			int i4 = (((i >> 21) | 0x80));
			int i5 =  ((i>> 28));
			al.add((byte) i1);
			al.add((byte) i2);
			al.add((byte) i3);
			al.add((byte) i4);
			al.add((byte) i5);
			return al;
		}else return al;
		
		
	}
	
	public static ArrayList<Byte> getSI32(int i){
		int tmp = i;
		if (i<0) i *=-1;
		
		ArrayList<Byte> al = new ArrayList<Byte>();
		
		if ( i <= 0x7F ){
			if (tmp<0){
				int i1 =(~i+1)| 0x80;
				al.add((byte) i1);
				al.add((byte) 0xFF);
				al.add((byte) 0xFF);
				al.add((byte) 0xFF);
				al.add((byte) 0x0F);
				return al;
			}
			al.add((byte) i);
			return al;
			
			
			
		}else if ( i <= 0x3FFF && i>= 0x80 ){
			int i1 =  ((i & 0x7F) | 0x80);
			int i2=  ((i >> 7));
			if (tmp<0){
				i1= (~i1+1)| 0x80;
				i2=~(i2);
				al.add((byte) i1);
				al.add((byte) i2);
				al.add((byte) 0xFF);
				al.add((byte) 0xFF);
				al.add((byte) 0x0F);
				
				return al;
			}
			
			al.add((byte) i1);
			al.add((byte) i2);
			return al;
			
		}else if ( i <= 0x1FFFFF  && i>=0x4000   ){
			int i1 = (((i & 0x7F) | 0x80));
			int i2 = (((i >> 7) | 0x80));
			int i3 = ((i>> 14));
			if (tmp<0){
				i1= (~i1+1)| 0x80;
				i2=(~i2| 0x80);
				i3=~(i3);
				al.add((byte) i1);
				al.add((byte) i2);
				al.add((byte) i3);
				al.add((byte) 0xFF);
				al.add((byte) 0x0F);
				return al;
				
			}
			al.add((byte) i1);
			al.add((byte) i2);
			al.add((byte) i3);
			return al;
			
		}else if ( i <= 0xFFFFFFF   && i>=0x200000    ){
			int i1 = (((i & 0x7F) | 0x80));
			int i2 =  (((i >> 7) | 0x80));
			int i3 =  (((i >> 14) | 0x80));
			int i4=  ((i>> 21));
			if (tmp<0){
				i1= (~i1+1)| 0x80;
				i2=(~i2| 0x80);
				i3=(~i3| 0x80);
				i4=~(i4);
				al.add((byte) i1);
				al.add((byte) i2);
				al.add((byte) i3);
				al.add((byte) i4);
				al.add((byte) 0x0F);
				
				return al;
			}
			al.add((byte) i1);
			al.add((byte) i2);
			al.add((byte) i3);
			al.add((byte) i4);
			
			return al;
			
			
		}else if (i>= 0x10000000    ){
			int i1 =  (((i & 0x7F) | 0x80));
			int i2 =  (((i >> 7) | 0x80));
			int i3 =  (((i >> 14) | 0x80));
			int i4 = (((i >> 21) | 0x80));
			int i5 =  ((i>> 28));
			if (tmp<0){
				i1= (~i1+1)| 0x80;
				i2=(~i2| 0x80);
				i3=(~i3| 0x80);
				i4=(~i4| 0x80);
				i5=~(i5);
				al.add((byte) i1);
				al.add((byte) i2);
				al.add((byte) i3);
				al.add((byte) i4);
				al.add((byte) i5);
				return al;
			}
			al.add((byte) i1);
			al.add((byte) i2);
			al.add((byte) i3);
			al.add((byte) i4);
			al.add((byte) i5);
			return al;
		}else return al;
		
		
	}
	
	public static  String formatInt(int  k ){
		String s = Integer.toBinaryString(k);
		String wynik ="";
		if (s.length()<8){
			int i = 8 - s.length();
			
			for (int n =0; n < i; n++){
				wynik += "0";
			}
			wynik+=s;
		}else{
			wynik = s.substring(0,8);
		}
		return wynik;
	}
	
	
	public static ArrayList<Integer> array(int a, int b, int c){
		ArrayList<Integer> al = new ArrayList<Integer>();
		al.add(a);
		al.add(b);
		al.add(c);
		return al;
	}
	
	public static ArrayList<Integer> array(int a, int b){
		ArrayList<Integer> al = new ArrayList<Integer>();
		al.add(a);
		al.add(b);
		return al;
	}
	
	
	
	public String print(String s,HashMap<String,Object> hm){
		Object o = hm.get(s);		
		if (o != null) return s + ":  " + o+ "\n";
		else return "";
	}
	
	
	public void konsola(String s){
		System.out.println(s);
	}
	
	
	
	public  byte[] toBytaJava(byte data) {
	
		return new byte[]{data};
	
	}

	
	public  byte[] toBytaJava(double data) {
		ByteArrayOutputStream byte_out = new ByteArrayOutputStream ();
		DataOutputStream data_out = new DataOutputStream (byte_out); 
		try {
			data_out.writeDouble(data);
		} catch (IOException e) {
			e.printStackTrace();
		}
		byte tmp[] = byte_out.toByteArray ();
		byte result [] = new byte[tmp.length];
		//to Little endian
		int ii=tmp.length;
		for(int i =0; i <tmp.length;i++ ){
			ii--;
			result[ii] =tmp[i]; 
		}
		
		return result;
	}
	
	public void out(String s){
		System.out.println(s);
	}
	
	public static Object getKeyFromValue(HashMap hm,Object value){
	    for(Object o:hm.keySet()){
	        if(hm.get(o).equals(value)) {
	            return o;
	        }
	    }
	    return 0;
	}
}
